﻿using System;
using System.Diagnostics;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Update
{
    public class PutToVideoVisitServiceStep : FilterBase<VideoVisitUpdateStateObject>
    {
        public override void Execute(VideoVisitUpdateStateObject state)
        {
            if (state.ExceptionOccured) return;
            if (!string.IsNullOrEmpty(state.FakeResponseType)) return;

            var vimtTmpUpdateAppointmentRequest = new VIMTTmpUpdateAppointmentRequest
            {
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                LogTiming = false,
                LogSoap = false,
                Debug = false,
                VIMTTmpUpdateAppointmentRequestDataInfo = state.Appointment
            };

            vimtTmpUpdateAppointmentRequest.VIMTTmpUpdateAppointmentRequestDataInfo.SamlToken = state.SamlToken;

            // Call the Enterprise Component to send the meeting info to Vyopta
            try
            {
                var timer = new Stopwatch();
                timer.Start();
                var response = vimtTmpUpdateAppointmentRequest.SendReceive<VIMTTmpUpdateAppointmentResponse>(MessageProcessType.Local);
                timer.Stop();
                state.EcProcessingTimeMs += (int)timer.ElapsedMilliseconds;
                if (response.ExceptionOccured)
                {
                    state.ExceptionOccured = true;
                    state.ExceptionMessage = response.ExceptionMessage;
                }
                else
                {
                    if (response.VIMTTmpUpdateAppointmentResponseDataInfo != null)
                    {
                        state.EcResponse = response;

                        if (response.VIMTTmpUpdateAppointmentResponseDataInfo.HttpStatusCode == "OK") return;
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = string.Format("The Video Visit Create Appointment VIMT message failed with HTTP status code {0}", response.VIMTTmpUpdateAppointmentResponseDataInfo.HttpStatusCode);
                    }
                    else
                    {
                        state.ExceptionOccured = true;
                        state.ExceptionMessage = "The VIMTTmpCreateAppointmentResponseDataInfo response value is null";
                    }
                }
            }
            catch (Exception ex)
            {
                var exceptionMessage = ex.Message;
                exceptionMessage += PipelineUtilities.BuildErrorMessage(ex);

                state.ExceptionOccured = true;
                state.ExceptionMessage = exceptionMessage;
            }
        }

    }
}